<?php

namespace App\Http\Controllers;

use App\Models\Project;
use App\Models\Contact;
use App\Models\User;
use App\Models\EmailTemplate;
use App\Models\Fields;
use App\Models\Rescultcode;
use App\Models\script;
use App\Models\SmsTemplate;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class ProjectController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role_or_permission:admin|view project']);
    }

    // Project dashboard view
    public function dashboard($id)
    {
        $project = Project::findOrFail($id);
        $contact = \App\Models\User::find($project->user_id);
        $direction = auth()->user()->order_by_contact ?? 'ASC';
        $assigned_to_name = "";

        // All contacts on which result code has been applied
        $code_applied_on = \App\Models\Activity::where("project_id", $id)
            ->whereNotNull("result_code_id")
            ->pluck("contact_id")->toArray();

        // Mimic getNextContact logic (simplified: get first flagged contact for project)
        $UserData = \App\Models\Contact::orderBy('id', $direction)
            ->where('project_id', $id)
            ->where(function ($query) {
                $query->where('assigned_to', auth()->user()->id)
                    ->orWhereNull('assigned_to');
            })
            ->where('flagged', 1)
            ->first();

        $activitydata = \App\Models\Activity::where('project_id', $id)
            ->where('contact_id', $UserData ? $UserData->id : null)
            ->orderBy('created_at', 'desc')->get();
        $resultcode = \App\Models\Rescultcode::where('project_id', $id)->where('active', true)->get();
        $script = \App\Models\script::where('project_id', $id)->orderBy('order', 'ASC')->get();
        $user = \App\Models\User::where('role', '!=', 'admin')->get();
        return view('staff.index', compact('contact', 'UserData', 'activitydata', 'resultcode', 'script', 'project', 'assigned_to_name', 'user'));
    }

    // Set project context in session and redirect
    public function setProjectContext($id)
    {
        session(['pid' => $id]);
        // Redirect to project dashboard or wherever appropriate
        return redirect()->route('project.dashboard', ['id' => $id]);
    }

    public function index()
    {
        // $projects=Project::where('user_id',auth()->user()->id)->get();
        $allprojects = Project::orderBy('id', 'DESC')->get();
        $activeprojects = Project::where('status', '1')->get();
        return view('admin.project', compact('allprojects', 'activeprojects'));
    }

    public function create()
    {

    }

    public function store(Request $request)
    {
        $validateData = $request->validate([
            'title' => 'required'
        ]);
        $project = Project::create([
            'title' => $request->title,
            'user_id' => auth()->user()->id
        ]);
        $notification = array(
            'alert-type' => 'success',
            'message' => 'Project Created Successfully'
        );
        return redirect()->back()->with($notification);
    }

    public function saveCopy(Request $request)
    {
        $validateData = $request->validate([
            'title' => 'required',
            'id' => 'required'
        ]);

        $record = Project::find($request->id);

        if ($request->title == $record->title) {
            $request->title = $request->title . ' Copy';
        }

        $project = Project::create([
            'title' => $request->title,
            'user_id' => auth()->user()->id,
            'index_id' => $record->index_id,
            'description' => $record->description,
            'type' => $record->type,
            'status' =>  $record->status,
            'date' => $record->date,
        ]);

        if ($record) {
            $email_templates = EmailTemplate::where('project_id', $request->id)->get();
            foreach ($email_templates as $email_template) {
                EmailTemplate::create(
                    [
                        'project_id' => $project->id,
                        'user_id' => $email_template->user_id,
                        'name' => $email_template->name,
                        'subject' => $email_template->subject,
                        'body' => $email_template->body,
                    ]
                );
            }


            $fields = Fields::where('project_id', $request->id)->get();
            foreach ($fields as $field) {
                Fields::create(
                    [
                        'field_name' => $field->field_name,
                        'column_name' => $field->column_name,
                        'field_tab' => $field->field_tab,
                        'field_status' => $field->field_status,
                        'field_visible' => $field->field_visible,
                        'field_permissions_caller_edit' => $field->field_permissions_caller_edit,
                        'field_permissions_caller_search' => $field->field_permissions_caller_search,
                        'field_type' => $field->field_type,
                        'field_data_lenght_min' => $field->field_data_lenght_min,
                        'field_data_lenght_mx' => $field->field_data_lenght_mx,
                        'project_id' => $project->id,
                        'index_id' => $field->index_id,
                    ]
                );
            }

            $resultcodes = Rescultcode::where('project_id', $request->id)->get();
            foreach ($resultcodes as $resultcode) {
                Rescultcode::create(
                    [
                        'email_template' => $resultcode->email_template,
                        'result_code' => $resultcode->result_code,
                        'project_id' => $project->id,
                        'result_description' => $resultcode->result_description,
                        'result_group' => $resultcode->result_group,
                        'active' => $resultcode->active,
                        'result_action' => $resultcode->result_action,
                        'dialing_action' => $resultcode->dialing_action,
                        'user_assignment' => $resultcode->user_assignment,
                        'lead_status' => $resultcode->lead_status,
                        'require_comments' => $resultcode->require_comments,
                        'recording' => $resultcode->recording,
                        'time' => $resultcode->time,
                        'assigned_to' => $resultcode->assigned_to,
                    ]
                );
            }

            $scripts = script::where('project_id', $request->id)->get();
            foreach ($scripts as $script) {
                script::create(
                    [
                        'order' => $script->order,
                        'script_title' => $script->script_title,
                        'script_text' => $script->script_text,
                        'project_id' => $project->id,
                    ]
                );
            }

            $smstemplates = SmsTemplate::where('project_id', $request->id)->get();
            foreach ($smstemplates as $smstemplate) {
                SmsTemplate::create(
                    [
                        'project_id' => $project->id,
                        'user_id' => $smstemplate->user_id,
                        'name' => $smstemplate->name,
                        'body' => $smstemplate->body,
                        'status' => $smstemplate->status,
                        'description' => $smstemplate->description,
                    ]
                );
            }
        }
        $notification = array(
            'alert-type' => 'success',
            'message' => 'Project Created Successfully'
        );
    }

    public function show($id)
    {
        //
    }

    public function edit(Request $request)
    {
        $project = Project::findOrFail($request->id);
        return $project;
    }

    public function update(Request $request)
    {
        $project = Project::findOrFail($request->update_id);
        $project->update([
            'title' => $request->title,
            'description' => $request->description,
            'date' => $request->date,
            'type' => $request->type,
            'status' => $request->status,
        ]);
        $notification = array(
            'alert-type' => 'success',
            'message' => 'Project Updated Successfully'
        );
        return redirect()->back();
    }
    public function destroy(Request $request)
    {
        $id = $request->delete_id;
        $project = Project::findOrFail($id);
        $project->delete();
        $notification = array(
            'alert-type' => 'success',
            'message' => 'Project Deleted Successfully'
        );
        return redirect()->back()->with($notification);
    }
}
