<!DOCTYPE html>
<html lang="en">

<head>
    <x-projecthead />
    
    @section('title')
        Custom Url(webhook)
    @endsection
</head>

<body>
    <x-projectnavbar />
    <div class="container">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <form action="{{ route('custom.url.store') }}" method="POST">
            @csrf
            <input type="hidden" name="user_id" value="{{ $user_id }}">
            <input type="hidden" name="project_id" value="{{ $project_id }}">
            <div class="card">
                <div class="card-header">
                    <h3>Custom Url(webhook)</h3>
                </div>
                @if (Session::has('error'))
                    <div class="alert alert-danger m-2">{{ Session::get('error') }}</div>
                @elseif(Session::has('success'))
                    <div class="alert alert-success m-2">{{ Session::get('success') }}</div>
                @else
                @endif

                <div class="card-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <label for="name">Name</label>
                                <input type="text" id="name" name="name" class="form-control" required>
                                <input type="hidden" id="dd" name="url_id" class="form-control" value="{{$id}}">
                                <label for="desc">Description</label>
                                <input type="text" id="desc" name="desc" class="form-control">
                                <label for="url">Posting Url</label>
                                <input type="text" id="url" name="url" class="form-control"
                                    value="{{ rtrim(config('app.url'),'/') . '/api/web/post?id=' . $id }}" readonly>
                                <label for="email">Email for Result Code</label>
                                <input type="email" id="email" name="email" class="form-control">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-header">
                    <h3>Options</h3>
                </div>
                <div class="card-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <label for="update">Update Existing Contacts</label>
                                <input type="checkbox" name="updateContact" id="update">

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <p>Update Contacts that have matching values for this field: </p>

                            </div>
                            <div class="col-md-6">
                                <select name="updatefield" id="" class="form-control">
                                    <option value="" selected>Select field</option>
                                    @foreach ($columns as $column)
                                        <option value="{{ $column }}">
                                            {{ str_replace('_', ' ', ucwords($column, '_')) }}</option>
                                    @endforeach
                                </select>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-header">
                    <h3>Field Mappings</h3>
                </div>
                <div class="card-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <button type="button" class="btn bg-custom text-white mb-2" id="addFieldBtn">Add Field</button>

                                <div class="" style="width: 100%;overflow-x:auto;">
                                    <table class="display text-center" style="width: 100%">
                                        <thead>
                                            <tr class="tabelHeader ">
                                                {{-- <th>
                                                <div class="d-flex align-items-center">
                                                    <input type="checkbox" class="mr-2" name=""
                                                        id="delete_multiple" /> Active
                                                </div>
                                            </th> --}}
                                                <th>SalesCallz Field</th>

                                                <th>Web form Field</th>

                                                <th>Default value</th>

                                            </tr>
                                        </thead>
                                        <tbody id="table-body">
                                            <tr>
                                                <td>
                                                    <select name="fields[]" id="" class="form-control" required>
                                                        <option value="" selected disabled>Select field</option>
                                                        @foreach ($columns as $column)
                                                            <option value="{{ $column }}">
                                                                {{ str_replace('_', ' ', ucwords($column, '_')) }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" name="webfields[]" class="form-control"
                                                        placeholder="Enter incoming field name" required>
                                                </td>
                                                <td>
                                                    <input type="text" name="defaultvalues[]" class="form-control"
                                                        placeholder="Enter default value">
                                                </td>
                                                <td>
                                                    <ion-icon onclick="removeRow(this)" class="closeicon" name="close-circle-outline"></ion-icon>
                                                </td>
                                            </tr>


                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn float-right bg-custom text-white mb-2">Create</button>
                </div>
            </div>
        </form>
    </div>




    <!-- Modal -->

    <x-projectfooter />
    <script>
    $("select option:selected").css("background-color","blue");

        const addFieldBtn = document.getElementById('addFieldBtn');
        const tableBody = document.getElementById('table-body');

        addFieldBtn.addEventListener('click', function() {
            const newRow = `
        <tr>
            <td>
                <select name="fields[]" id="" class="form-control" required>
                                                    <option value="" selected disabled>Select field</option>
                                                    @foreach ($columns as $column)
                                                        <option value="{{ $column }}">
                                                            {{ str_replace('_', ' ', ucwords($column, '_')) }}</option>
                                                    @endforeach
                                                </select>
            </td>
            <td>
                <input type="text" name="webfields[]" class="form-control" placeholder="Enter incoming field name" required>
            </td>
            <td>
                <input type="text" name="defaultvalues[]" class="form-control" placeholder="Enter default value">
            </td>
            <td><button class="btn btn-danger" onclick="removeRow(this)">Remove</button></td>
        </tr>
    `;
            tableBody.insertAdjacentHTML('beforeend', newRow);
        });




        function removeRow(button) {
            var row = button.parentNode.parentNode;
            row.parentNode.removeChild(row);
        }
    </script>

</body>

</html>
