<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CrmController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\DealController;
use App\Http\Controllers\ListController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AgentController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\IndexController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\ActivityController;
use App\Http\Controllers\CompaignController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ResultCodeController;
use App\Http\Controllers\AppointmentController;
use App\Http\Controllers\CustomWebhookController;
use App\Http\Controllers\FilterDataController;
use App\Http\Controllers\GoogleAdsWebhookController;
use App\Http\Controllers\DncController;
use App\Http\Controllers\PermissionController;
use Illuminate\Support\Facades\Artisan;

//auth



Route::get('/api_users/{token}', [UserController::class, 'api_index']);
Route::get('/api_deal_data_insert/{token}', [UserController::class, 'api_deals_post']);
Route::get('/clear-cache', function () {
    // Clear the application cache
    Artisan::call('cache:clear');

    // Run Composer's autoloader to refresh it
    exec('composer dump-autoload');

    // Redirect back to a page or show a success message
    return redirect()->back()->with('success', 'Cache cleared and Composer autoload updated.');
});

Route::get('/run', function () {
    Artisan::call('queue:flush');

});

Route::get('/', [IndexController::class, 'index'])->name('index');

Route::get('/', [IndexController::class, 'index'])->name('index');
Route::post('/signin', [IndexController::class, 'signin']);
Route::get('/logout', [IndexController::class, 'logout']);
// Route::get('/clear-cache', function () {
//     // Run the cache:clear command
//     $exitCode = Artisan::call('cache:clear');

//     // Check if the command was successful
//     if ($exitCode === 0) {
//         return "Cache cleared successfully!";
//     } else {
//         return "Cache clear failed!";
//     }
// });
Route::get('user/email-send', [DashboardController::class, 'email']);
//ini_set('display_errors', '1');
//ini_set('display_startup_errors', '1');
//error_reporting(E_ALL);
ini_set('memory_limit', '-1');

Route::middleware(['auth','checkSmtp'])->group(function () {
    //Admin Routes
    Route::get('/admin', [AdminController::class, 'index']);
    Route::get('/admin/profile', [AdminController::class, 'profile']);
    Route::PUT('/admin/profile-update', [AdminController::class, 'profile_update']);
    Route::get('/test', function () {
        return getTimeZoneWithCurl();
    });
    //user
    Route::get('/admin/users', [UserController::class, 'index']);
    Route::post('/admin/add-user', [UserController::class, 'store']);
    Route::get('/admin/view-user', [UserController::class, 'show']);
    Route::get('/admin/edit-user', [UserController::class, 'edit']);
    Route::PUT('/admin/update-user', [UserController::class, 'update']);
    Route::DELETE('/admin/delete-user', [UserController::class, 'destroy']);
    Route::get('/admin/delete-user/{user_id}', [UserController::class, 'destroy']);
    Route::get('/admin/mass-user', [UserController::class, 'mass_delete']);
    //Lists
    Route::get('/admin/lists', [ListController::class, 'index']);
    Route::post('/admin/add-list', [ListController::class, 'store']);
    Route::get('/admin/view-list', [ListController::class, 'show']);
    Route::get('/admin/edit-list', [ListController::class, 'edit']);
    Route::PUT('/admin/update-list', [ListController::class, 'update']);
    Route::DELETE('/admin/delete-list', [ListController::class, 'destroy']);
    Route::get('/admin/mass-list', [ListController::class, 'mass_delete']);
    //Agents
    Route::get('/admin/remote-agent', [AgentController::class, 'index']);
    Route::post('/admin/add-agent', [AgentController::class, 'store']);
    Route::get('/admin/view-agent', [AgentController::class, 'show']);
    Route::get('/admin/edit-agent', [AgentController::class, 'edit']);
    Route::PUT('/admin/update-agent', [AgentController::class, 'update']);
    Route::DELETE('/admin/delete-agent', [AgentController::class, 'destroy']);
    Route::get('/admin/mass-agent', [AgentController::class, 'mass_delete']);
    //Group
    Route::get('/admin/groups', [GroupController::class, 'index']);
    Route::post('/admin/add-group', [GroupController::class, 'store']);
    Route::get('/admin/view-group', [GroupController::class, 'show']);
    Route::get('/admin/edit-group', [GroupController::class, 'edit']);
    Route::PUT('/admin/update-group', [GroupController::class, 'update']);
    Route::DELETE('/admin/delete-group', [GroupController::class, 'destroy']);
    Route::get('/admin/mass-group', [AgentController::class, 'mass_delete']);
    //Compaign

    Route::get('/admin/compaigns', [CompaignController::class, 'index']);
    Route::post('/admin/add-compaign', [CompaignController::class, 'store']);
    Route::get('/admin/view-compaign', [CompaignController::class, 'show']);
    Route::get('/admin/edit-compaign', [CompaignController::class, 'edit']);
    Route::PUT('/admin/update-compaign', [CompaignController::class, 'update']);
    Route::DELETE('/admin/delete-compaign', [CompaignController::class, 'destroy']);
    Route::get('/admin/mass-compaign', [AgentController::class, 'mass_delete']);
    //Admin Reporting
    Route::get('/admin/reporting', [ReportController::class, 'index']);

    //company
    Route::get('/admin/setting', [CompanyController::class, 'index']);
    Route::post('/admin/company_setting', [CompanyController::class, 'store']);
    //user deal
    Route::get('/admin/deal', [DealController::class, 'index']);
    Route::post('/add-deal', [DealController::class, 'store']);
    //user project
    Route::get('/project', [ProjectController::class, 'index'])->name('project');
    Route::post('/project', [ProjectController::class, 'store']);
    Route::post('/copy-project', [ProjectController::class, 'saveCopy']);
    Route::DELETE('/project-delete', [ProjectController::class, 'destroy']);
    Route::PUT('/update-project', [ProjectController::class, 'update']);
    Route::get('/edit-project', [ProjectController::class, 'edit']);

    //user calendar
    Route::get('/calendar', [AppointmentController::class, 'calendar']);
    Route::post('/add-appointment', [AppointmentController::class, 'store']);
    Route::get('/appointment', [AppointmentController::class, 'index']);
    Route::get('/edit-appointment', [AppointmentController::class, 'edit']);
    Route::PUT('/update-appointment', [AppointmentController::class, 'update']);
    //user add contact
    Route::get('/add-contact', [ContactController::class, 'create']);
    Route::get('/edit-contact/{id}', [ContactController::class, 'edit']);
    Route::post('/add-contact', [ContactController::class, 'store']);
    Route::post('/update-contact', [ContactController::class, 'update_contact']);
    Route::get('add-contactdashboard/{id}', [ContactController::class, 'addcontact']);

    Route::get('/get-job-data/{id}', [ContactController::class, 'update_job_data'])->name('get-job-data');
    Route::post('/save-mapping', [ContactController::class, 'save_maping'])->name('save-maping');
    Route::get('/get-mapping-scheme/{id}', [ContactController::class, 'get_maping'])->name('get-mapping-scheme');
    
    Route::post('/update-details', [ContactController::class, 'update_details']);
    Route::post('/update-caller-details', [ContactController::class, 'update_caller_details'])->name('update_caller_details');
    Route::get('/admin/contacts', [ContactController::class, 'index'])->name('contact.index_1');
    Route::get('/admin/contacts/csv', [ContactController::class, 'all_csv'])->name('contact.csv_all');

    Route::get('/delete_contacts/{id}', [ContactController::class, 'destroy']);


    //user Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index']);
    Route::PUT('/update-dashboard', [DashboardController::class, 'update']);
    //user Crm

    Route::get('/admin/crm', [CrmController::class, 'index']);
    //user chart chat
    Route::get('/admin/chat', [ChatController::class, 'index']);
    Route::get('/search', [SearchController::class, 'index']);
    //user Dashboard
    // Route::get('/my-dashboard',[DashboardController::class,'dashboard']);

    //user Document
    Route::get('/documents', [DocumentController::class, 'index']);
    Route::post('/documents', [DocumentController::class, 'store']);
    Route::post('/update-document', [DocumentController::class, 'update']);
    Route::get('/show-document', [DocumentController::class, 'show']);
    Route::DELETE('/delete-document', [DocumentController::class, 'destroy']);
    //user activity
    Route::post('/add-activity', [ActivityController::class, 'store']);
    //user task
    Route::post('/add-task', [TaskController::class, 'store']);
    //User Resultcode
    Route::get('result/{id}', [ResultCodeController::class, 'index']);
    Route::post('addresultcode', [ResultCodeController::class, 'addresultcode']);
    Route::post('update-setting', [ResultCodeController::class, 'updateSetting']);
    // Route::post('addresult',[ResultCodeController::class,'AddResult']);
    Route::get('admin/resultcode', [ResultCodeController::class, 'ResultCode'])->name('resultcode');
    Route::get('resultcodedel/{id}', [ResultCodeController::class, 'destroy']);
    Route::post('resultCodeEdit', [ResultCodeController::class, 'resultCodeEdit']);

    Route::get('dashboard/{id}', [DashboardController::class, 'DashboardDetails'])->name('dashboard');
    Route::get('dashboard/{id}/{contactId}', [DashboardController::class, 'DashboardDetails']);
    Route::get('admin/script', [ResultCodeController::class, 'script']);
    Route::post('admin/updateScript', [ResultCodeController::class, 'updateScript']);
    Route::post('addscript', [ResultCodeController::class, 'addscript']);
    Route::post('editscript', [ResultCodeController::class, 'editscript']);
    Route::get('scriptdel/{id}', [ResultCodeController::class, 'scriptdel']);
    Route::get('getscript/{id}/{contact}', [ResultCodeController::class, 'getscript']);
    Route::get('admin/recchecked/{id}', [ResultCodeController::class, 'recchecked']);
    Route::get('admin/recunchecked/{id}', [ResultCodeController::class, 'recunchecked']);
    Route::get('admin/comchecked/{id}', [ResultCodeController::class, 'comchecked']);
    Route::get('admin/comunchecked/{id}', [ResultCodeController::class, 'comunchecked']);
    Route::get('admin/activechecked/{id}', [ResultCodeController::class, 'activechecked']);
    Route::get('admin/activeunchecked/{id}', [ResultCodeController::class, 'activeunchecked']);
    Route::get('reqcontact/{id}', [DashboardController::class, 'reqcontact']);
    Route::get('admin/emailsms', [DashboardController::class, 'emailsms']);
    Route::get('admin/email', [DashboardController::class, 'add_email']);
    Route::get('admin/sms', [DashboardController::class, 'add_sms']);
    Route::get('admin/call-management', [DashboardController::class, 'callManage']);
    Route::get('call-management', [DashboardController::class, 'callManagement']);
    Route::get('permissions-roles', [PermissionController::class, 'index']);
    Route::get('telnyx_api', [DashboardController::class, 'telnyx_api']);
    Route::get('set-permissions/{id}', [PermissionController::class, 'create']);
    Route::post('/upd_telnyx_api', [DashboardController::class, 'telnyx_api_save']);
    Route::post('save-permissions/{id}', [PermissionController::class, 'save']);
    Route::post('save-new-permission/{id}', [PermissionController::class, 'saveNew']);
    Route::post('checkCallerInContacts', [DashboardController::class, 'checkCallerInContacts']);

    Route::get('/return-dashboard', [DashboardController::class, 'dashboardreturn']);
    Route::match(['get', 'post'], '/newdashboard', [DashboardController::class, 'newdashboard']);

    ///// Email Template Routes
    Route::get('admin/email-send', [DashboardController::class, 'email']);
    Route::get('admin/add-contact-variable', [DashboardController::class, 'addVariable']);
    Route::post('admin/deleteVariable/{id}', [DashboardController::class, 'deleteVariable']);
    Route::post('admin/saveVariable', [DashboardController::class, 'saveVariable']);
    Route::post('/renameEmail', [DashboardController::class, 'renameEmailTemp']);
    Route::get('admin/deleteEmailTemp/{id}', [DashboardController::class, 'deleteEmailTemp']);
    Route::post('/addEmail', [DashboardController::class, 'addEmailTemp']);
    Route::post('/resultEmail', [DashboardController::class, 'resultEmail']);

    ///// SMS Template Routes
    Route::get('admin/sms-templates', [DashboardController::class, 'smsTemplates']);
    Route::get('admin/sms-add/{id?}', [DashboardController::class, 'smsForm']);
    Route::post('admin/sms-add', [DashboardController::class, 'smsFormPost']);
    Route::get('smsTemDelete/{id}', [DashboardController::class, 'smsTemDelete']);



    Route::get('searchuser/{id}', [DashboardController::class, 'searchuser']);

    Route::get('/clear', function () {
        $res = Artisan::call('optimize:clear');
        return $res;
    });

    Route::get('/user', [DashboardController::class, 'Userdetails']);
    Route::post('/user/change-project', [DashboardController::class, 'changeProject']);
    //calendar rputes
    Route::get('/get-calendar', function () {
        return view('admin.contact-calendar');
    });
    Route::get('/get-calendar-data', [ActivityController::class, 'getCalendarData'])->name('user.getCalenderData');
    Route::get('/get-contact-data', [ActivityController::class, 'getContectData'])->name('user.getContactData');
    Route::get('/create-user', [DashboardController::class, 'create']);
    Route::post('/add-user', [UserController::class, 'store']);
    Route::get('/edit-user/{id}', [DashboardController::class, 'edit']);
    Route::get('/smtp-user/{id}', [DashboardController::class, 'smtp']);
    Route::post('/update-smtp', [DashboardController::class, 'update_smtp']);
    Route::post('/update-user/{id}', [UserController::class, 'store']);
    Route::post('/update-user-telnyx}', [UserController::class, 'update_telnyx_config'])->name('update_user_telnyx_config');

    // User Active
    Route::get('/useractive/{id}', [UserController::class, 'checkeduser']);
    Route::get('/editprofile/{id}', [UserController::class, 'editprofile']);
    Route::get('/dialinfo/{id}', [UserController::class, 'dialinfo']);
    Route::get('/allowswitch/{id}', [UserController::class, 'allowswitch']);
    Route::get('/mystats/{id}', [UserController::class, 'mystats']);
    Route::get('/changeproject/{id}', [UserController::class, 'changeproject']);

    Route::match(['get', 'post'], '/filter-contacts/{id}', [DashboardController::class, 'filterProject'])->name('filter-contacts');
    Route::get('/order-route', [DashboardController::class, 'orderRoute']);
    Route::post('/update-order-routing', [DashboardController::class, 'orderRouteUpdate']);


    /*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                    Routes added by Mahar Nisar
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*/


    //Custom fields

    Route::get('fields/duplicate/{id}', 'App\Http\Controllers\FieldsController@duplicate')->name('fields.duplicate');
    Route::resource('fields', 'App\Http\Controllers\FieldsController');
    Route::get('system_fields', 'App\Http\Controllers\FieldsController@index_system');
    Route::get('fields/delete/{id}', 'App\Http\Controllers\FieldsController@destroy');
    Route::get('fields-move/{id}/{direction}', 'App\Http\Controllers\FieldsController@move');

    //Contacts import


    Route::get('download-contacts-smaple', [ContactController::class, 'downloadcontactssample']);
    Route::get('import-contacts', [ContactController::class, 'importcontacts']);
    Route::post('import-contacts-store', [ContactController::class, 'importcontactsstore'])->name('import-contacts-store');
    Route::post('/import-contacts-process', [ContactController::class, 'processImport'])->name('import-contacts-process');
    // Deals
    Route::get('deals', [ContactController::class, 'deals']);
    Route::get('import-files', [ContactController::class, 'deals']);

    //Collabrator


    Route::post('add-collaborator', [UserController::class, 'addcollabrator']);

    // ------------------------Routes ADDED BY ABDUR REHMAN-------------------------

    // query builder

    Route::view('query-builder','admin.query-builder')->name('query-builder');
    Route::get('custom-url/all',[CustomWebhookController::class,'index'])->name('custom-url-table');
    Route::view('query-builder2','admin.query-builder2')->name('query-builder2');
    Route::post('query-builder/run',[ContactController::class,'filterContact'])->name('query-builder.run');
    Route::post('/delete_data', [FilterDataController::class, 'DeleteData'])->name('data.delete');
    Route::post('/export_data', [FilterDataController::class, 'Exportdata'])->name('data.export');
    Route::post('/copy_data', [FilterDataController::class, 'Copydata'])->name('data.copy');
    Route::post('/flag_data', [FilterDataController::class, 'flagContacts'])->name('data.flag');
    Route::post('/unflag_data', [FilterDataController::class, 'unflagContacts'])->name('data.unflag');
    Route::post('/google-ads/webhook', [GoogleAdsWebhookController::class, 'handle']);
    Route::post('/web/post', [CustomWebhookController::class, 'handle']);
    Route::get('/custom-url/create',[CustomWebhookController::class,'createCustomUrl'])->name('custom.url.create');
    Route::post('/custom-url/store',[CustomWebhookController::class,'storeCustomUrl'])->name('custom.url.store');
    Route::get('/delete-custom-url/{id}', [CustomWebhookController::class, 'destroy']);
    Route::get('/edit-custom-url/{id}', [CustomWebhookController::class, 'edit']);
    Route::post('/update-custom-url/{id}', [CustomWebhookController::class, 'update']);

    // directing to deals project

    Route::get('/deals/{id}', [DashboardController::class, 'dealsProject']);
    Route::post('/search_telnyx_number', [UserController::class, 'search_telnyx_number'])->name('search_telnyx_number');
    Route::post('/buy_telnyx_number', [UserController::class, 'buy_telnyx_number'])->name('buy_telnyx_number');
    Route::post('/add_telnyx_number_tag', [UserController::class, 'add_telnyx_number_tag'])->name('add_telnyx_number_tag');
    // flagged contact page
    Route::get('/flagged-contacts', [ContactController::class, 'flagged_contacts']);
    //update contact call record
    Route::post('/update_contact_call', [ContactController::class, 'update_contact_call'])->name('update_contact_call');
    Route::post('/delete_csv_con', [ContactController::class, 'delete_csv_con'])->name('delete_csv_con');
    Route::get('/list-next-contacts', [DashboardController::class, 'list_next_contacts']);
    
    Route::get('/change-password', [UserController::class, 'showChangePasswordForm'])->name('change.password');
    Route::post('/change-password', [UserController::class, 'changePassword'])->name('update.password');
    Route::post('/dnc-update-password', [DncController::class, 'update_password'])->name('dnc.update-password');
});

Route::get('/dnc', [DncController::class, 'index'])->name('dnc.index');
Route::get('/testdnc', [DncController::class, 'testdnc']);
Route::post('/dnc', [DncController::class, 'login_dnc'])->name('dnc.login');
Route::get('/dnc-export-list', [DncController::class, 'export_list'])->name('dnc.export-list');
Route::post('/dnc-list', [DncController::class, 'store'])->name('dnc.store');
Route::post('/dnc-check/contact', [DncController::class, 'check'])->name('dnc.check');
Route::post('/dnc-import', [DncController::class, 'import'])->name('dnc.import');
Route::put('/dnc-list/{id}', [DncController::class, 'update'])->name('dnc.update');
Route::delete('/dnc-list/{id}', [DncController::class, 'destroy'])->name('dnc.destroy');
Route::get('/project/context/{id}', [App\Http\Controllers\ProjectController::class, 'setProjectContext'])->name('project.setContext');
// Project dashboard route for redirect after setting context
Route::get('/project/dashboard/{id}', [App\Http\Controllers\ProjectController::class, 'dashboard'])->name('project.dashboard');