@extends('layouts.app')
@section('title')
    Profile
@endsection
@section('content')
    @include('partials.navbar')
    <div class="content-wrapper">
        @include('partials.sidebar')

        <main class="main-container" id="main_container">
            <div class="container-fluid w-100">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="text-info">Profile</h5>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="ms-2">
                                        <span>
                                            <i class='bx bx-cog'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-caret-down'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-sync'></i>
                                        </span>
                                    </div>

                                </div>

                            </div>
                            <div class="card-body">
                                <div class="table-wrapper">
                                    <div class="row">
                                        <form action="{{route('profile.update')}}" method="post">
                                            @csrf
                                            <div class="row mb-2">
                                                <label for="user_name" class="col-sm-2 col-form-label"> Name</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control form-control-sm" name="name"
                                                        value="{{$user->name}}" id="user_name">
                                                </div>
                                                @error('name')
                                                    <p class="text-danger fw-semibold">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="row mb-2">
                                                <label for="email" class="col-sm-2 col-form-label"> Email</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control form-control-sm" name="email"
                                                        value="{{$user->email}}" id="email">
                                                </div>
                                                @error('email')
                                                    <p class="text-danger fw-semibold">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="row mb-2">
                                                <label for="password" class="col-sm-2 col-form-label"> Password</label>
                                                <div class="col-sm-10">
                                                    <input type="password" class="form-control form-control-sm" name="password"
                                                        value="" id="password">
                                                </div>
                                                <span><code>leave it empty if dont want to change password</code></span>
                                                @error('password')
                                                    <p class="text-danger fw-semibold">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="row mb-2">
                                                <label for="email_password" class="col-sm-2 col-form-label"> Gmail App Password</label>
                                                <div class="col-sm-10">
                                                    <input type="email_password" class="form-control form-control-sm" name="email_password"
                                                        value="" id="email_password">
                                                </div>
                                                @error('email_password')
                                                    <p class="text-danger fw-semibold">{{ $message }}</p>
                                                @enderror
                                            </div>
                                                <div class="row mb-2">
                                                <div>
                                                    <label for="app_slug" class="col-sm-2 col-form-label"> APP Slug</label>
                                                    <code>https://steadycapital.app/{{$app_slug}}</code>
                                                </div>
                                            </div>
                                            <input type="hidden" name="id" value={{$user->id}}>
                                            <div class="modal-footer">
                                                <input type="submit" class="btn submit_button" value="Save">
                                            </div>
                                        </form>


                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
    </div>
    </div>
    </main>
    </div>

    @if (Session::has('success'))
        <script>
            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: "{!! Session::get('success') !!}",
                showConfirmButton: false,
                timer: 1500
            });
        </script>
    @endif
    @if (Session::has('error'))
    <script>
        Swal.fire({
            position: 'top-end',
            icon: 'error',
            title: "{!! Session::get('error') !!}",
            showConfirmButton: false,
            timer: 1500
        });
    </script>
@endif
    </body>
@endsection
