@extends('layouts.app')
@section('title')
    Dashboard
@endsection
@section('content')
@include('partials.navbar')
<div class="content-wrapper">
    @include('partials.sidebar')
    <main class="main-container" id="main_container">
        <div class="container-fluid w-100">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="text-info">Dashboard</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="card text-white bg-primary mb-3">
                                        <div class="card-header">Total Deals</div>
                                        <div class="card-body">
                                            <h5 class="card-title">{{ $totalDeals }}</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card text-white bg-success mb-3">
                                        <div class="card-header">Funded Deals</div>
                                        <div class="card-body">
                                            <h5 class="card-title">{{ $fundedDeals }}</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card text-white bg-warning mb-3">
                                        <div class="card-header">Total Commissions</div>
                                        <div class="card-body">
                                            <h5 class="card-title">${{ number_format($totalCommissions, 2) }}</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card text-white bg-info mb-3">
                                        <div class="card-header">Users</div>
                                        <div class="card-body">
                                            <h5 class="card-title">{{ $totalUsers }}</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
@endsection
