@extends('layouts.app')
@section('title')
    Deals
@endsection
@section('content')

    @include('partials.navbar')
    <div class="wrapper">
        @include('partials.sidebar')
        <main class="main-container" id="main_container">
            <div class="container-fluid w-100">
                <div class="row">
                    {{-- <div class="col-12 mt-1">

                        @foreach ($errors->all() as $message)
                            <p class="text-danger fw-bold">{{ $message }}</p>
                        @endforeach
                    </div> --}}
                    <div class="col-md-6">
                        <p><span class="text-muted fw-semibold">Advanced Search ,</span>
                            <span class="text-info fw-bold">Search Results</span>
                        </p>
                    </div>
                    <div class="col-md-6">
                        <div class="input-group mb-2">
                            <input type="text" class="form-control form-control-sm" placeholder="Search by Name,Term">
                            <span class="input-group-text" id="basic-addon2">
                                <i class='fas fa-search'></i>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="card h-100">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="text-info">SEARCH RESULTS</h5>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <button style="box-shadow: -5px 0px rgb(0, 174, 255);" type="button"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal2"
                                            class="btn custom-btn me-3">
                                            <i class='fas fa-dollar-sign'></i>
                                            Open
                                        </button>
                                    </div>
                                    <div>
                                        <button style="box-shadow: -5px 0px rgb(0, 174, 255);" type="button"
                                            class="btn custom-btn">
                                            <i class='fas fa-bars'></i>
                                            All
                                        </button>
                                    </div>
                                    <div>
                                        <button style="box-shadow: -5px 0px rgb(255, 238, 0);" type="button"
                                            class="btn custom-btn ms-3">
                                            <i class='fas fa-edit'></i>
                                            Line
                                        </button>
                                    </div>
                                    <div>
                                        @unless(auth()->user()->hasRole('Lender'))
                                            <button style="box-shadow: -5px 0px rgb(255, 0, 0);" type="button"
                                                class="btn custom-btn ms-3" data-bs-toggle="modal" data-bs-target="#add_deal">
                                                <i class='fas fa-plus'></i>
                                                New Deal
                                            </button>
                                        @endunless
                                    </div>

                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-caret-down'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-sync'></i>
                                        </span>
                                    </div>

                                </div>

                            </div>
                            <div class="card-body">
                                <div class="float-right" style="text-align: right;">
                                    <span> Note Visibility:</span>
                                    <div style="display: inline-block;">
                                        <input type="checkbox" name="visibility" value="appr" onclick="toggleVisibility('appr')"> Approved
                                        <input type="checkbox" name="visibility" value="pend" onclick="toggleVisibility('pend')"> Pending
                                        <input type="checkbox" name="visibility" value="dec" onclick="toggleVisibility('dec')"> Declined
                                    </div>
                                </div>
                                <script>
                                    function toggleVisibility(visibility) {
                                            if ($('input[name=visibility][value=appr]').is(':checked')) {
                                                $('.appr_span').show();
                                            } else {
                                                $('.appr_span').hide();
                                            }
                                            if ($('input[name=visibility][value=pend]').is(':checked')) {
                                                $('.pen_span').show();
                                            } else {
                                                $('.pen_span').hide();
                                            }
                                            if ($('input[name=visibility][value=dec]').is(':checked')) {
                                                $('.dec_span').show();
                                            } else {
                                                $('.dec_span').hide();
                                            }
                                    }
                                </script>                        
                                <div class="table-wrapper">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>

                                                <th scope="col">Company</th>
                                                <th scope="col">Primary Contact</th>
                                                <th scope="col">Lender Notes</th>
                                                <th scope="col">Phone Number</th>
                                                <th scope="col">Email Address</th>
                                                <th scope="col">Rep(s) <a href="/deal/asc/rep"><button class="btn btn-sm btn-warning"> <i class="fas fa-filter"></i>filter</button></a></th>
                                                <th scope="col">Last Contacted</th>
                                                <th scope="col">Action</th>
                                            </tr>
                                            <tr>
                                                <form action="{{ url('deal/search') }}" method="post">
                                                    @csrf
                                                    <th><input type="text" name="company_name"class="form-control" />
                                                    </th>
                                                    <th><input type="text" name="marchant_name"class="form-control" />
                                                    </th>
                                                    <th><input type="text" name="notes"class="form-control" /></th>
                                                    <th><input type="text" name="phone_number"class="form-control" />
                                                    </th>
                                                    <th><input type="email" name="email"class="form-control" /></th>
                                                    <th><input type="text" name="sale_rep"class="form-control" /></th>
                                                    <th><input type="date" name="last_contacted"class="form-control" />
                                                    </th>
                                                    <th>
                                                        <button type="submit"
                                                            class="btn btn-sm btn-primary">Search</button>
                                                    </th>
                                                </form>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {{-- submited --}}
                                            <tr class="collapse-container">
                                                <td colspan="8">
                                                    <div class="header-wrapper">
                                                        <a data-bs-toggle="collapse" class="collapse-link"
                                                            href="#submitted" role="button" aria-expanded="false"
                                                            aria-controls="submitted" style="min-width:10rem">
                                                            Submitted({{ $submitted->count() }})
                                                        </a>
                                                        @if($submitted->count() > 0)
                                                            <a href="/deal/asc/submitted">
                                                                <button class="btn btn-sm order-btn">▲</button>
                                                            </a>
                                                            <a href="/deal/desc/submitted">
                                                                <button class="btn btn-sm order-btn">▼</button>
                                                        
                                                            </a>
                                                        @endif
                                                    </div>
                                                    
                                                </td>
                                            @if ($submitted->count() > 0)
                                                @foreach ($submitted as $item)
                                                    <tr class="collapse {{($open_s)?'show':''}}" id="submitted">

                                                        <td>
                                                            <a href="/show_deal/{{ $item->id }}"
                                                                style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                                {{ $item->company_name }}.
                                                            </a>
                                                        </td>
                                                        <td>{{ $item->marchant_name }}</td>
                                                        <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                        <td>{{ $item->phone_number }}</td>
                                                        <td>{{ $item->email }}</td>
                                                        <td>{{ $item->sale_rep }}</td>
                                                        <td>{{ $item->date_submitted }}</td>
                                                        <td style="display: flex;">
                                                            <button type="button" class="btn btn-danger delete_deal"
                                                                data-id="{{ $item->id }}">
                                                                Delete
                                                            </button>
                                                            <button type="button" data-id="{{ $item->id }}"
                                                                class=" ms-2 btn-info btn-sm btn edit_deal">
                                                                Edit
                                                            </button>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr></tr>
                                            @endif





{{--                                            <td colspan="8">--}}
{{--                                                <div class="header-wrapper">--}}
{{--                                                    <a data-bs-toggle="collapse" class="collapse-link" href="#proc" role="button" aria-expanded="false" aria-controls="proc" style="min-width:10rem">--}}
{{--                                                        Accepted({{ $accepted->count() }})--}}
{{--                                                    </a>--}}
{{--                                                    @if($accepted->count() > 0)--}}
{{--                                                        <a href="/deal/asc/proc">--}}
{{--                                                            <button class="btn btn-sm order-btn">▲</button>--}}
{{--                                                        </a>--}}
{{--                                                        <a href="/deal/desc/proc">--}}
{{--                                                            <button class="btn btn-sm order-btn">▼</button>--}}

{{--                                                        </a>--}}
{{--                                                    @endif--}}
{{--                                                </div>--}}
{{--                                            </td>--}}
{{--                                            @if ($accepted->count() > 0)--}}
{{--                                                @foreach ($accepted as $item)--}}
{{--                                                    <tr class="collapse {{($open_proc)?'show':''}}" id="proc">--}}

{{--                                                        <td>--}}
{{--                                                            <a href="/show_deal/{{ $item->id }}"--}}
{{--                                                               style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">--}}
{{--                                                                {{ $item->company_name }}.--}}
{{--                                                            </a>--}}
{{--                                                        </td>--}}
{{--                                                        <td>{{ $item->marchant_name }}</td>--}}
{{--                                                        <td style="display: flex;">--}}
{{--                                                            @php--}}
{{--                                                                $approvedNotes = [];--}}
{{--                                                                $pendingNotes = [];--}}
{{--                                                                $declinedNotes = [];--}}

{{--                                                                foreach ($item->lenders as $lender) {--}}
{{--                                                                if ($lender->pivot->status == 'Approved') {--}}
{{--                                                                $approvedNotes[] = $lender->pivot->note;--}}
{{--                                                                } elseif ($lender->pivot->status == 'Pending') {--}}
{{--                                                                $pendingNotes[] = $lender->pivot->note;--}}
{{--                                                                } elseif ($lender->pivot->status == 'Declined') {--}}
{{--                                                                $declinedNotes[] = $lender->pivot->note;--}}
{{--                                                                }--}}
{{--                                                                }--}}
{{--                                                            @endphp--}}

{{--                                                            @foreach ($approvedNotes as $note)--}}
{{--                                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>--}}
{{--                                                            @endforeach--}}

{{--                                                            @foreach ($pendingNotes as $note)--}}
{{--                                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}--}}
{{--                                                                </p>--}}
{{--                                                            @endforeach--}}

{{--                                                            @foreach ($declinedNotes as $note)--}}
{{--                                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>--}}
{{--                                                            @endforeach--}}
{{--                                                        </td>--}}
{{--                                                        <td>{{ $item->phone_number }}</td>--}}
{{--                                                        <td>{{ $item->email }}</td>--}}
{{--                                                        <td>{{ $item->sale_rep }}</td>--}}
{{--                                                        <td>{{ $item->date_submitted }}</td>--}}
{{--                                                        <td style="display: flex;">--}}
{{--                                                            <button type="button" class="btn btn-danger delete_deal"--}}
{{--                                                                    data-id="{{ $item->id }}">--}}
{{--                                                                Delete--}}
{{--                                                            </button>--}}
{{--                                                            <button type="button" data-id="{{ $item->id }}"--}}
{{--                                                                    class=" ms-2 btn-primary btn-sm btn">--}}
{{--                                                                Edit--}}
{{--                                                            </button>--}}
{{--                                                            @if($errors->any())--}}
{{--                                                                <script>--}}
{{--                                                                    $(document).ready(function () {--}}
{{--                                                                        $('#add_deal').modal('show');--}}
{{--                                                                    });--}}
{{--                                                                </script>--}}
{{--                                                            @endif--}}
{{--                                                        </td>--}}
{{--                                                    </tr>--}}
{{--                                                @endforeach--}}
{{--                                            @else--}}
{{--                                                <tr></tr>--}}
{{--                                            @endif--}}





                                            {{-- processor --}}
                                            <td colspan="8">
                                                <div class="header-wrapper">
                                                    <a data-bs-toggle="collapse" class="collapse-link" href="#proc" role="button" aria-expanded="false" aria-controls="proc" style="min-width:10rem">
                                                        Processor({{ $proc->count() }})
                                                    </a>
                                                    @if($proc->count() > 0)
                                                        <a href="/deal/asc/proc">
                                                            <button class="btn btn-sm order-btn">▲</button>
                                                        </a>
                                                        <a href="/deal/desc/proc">
                                                            <button class="btn btn-sm order-btn">▼</button>
                                                    
                                                        </a>
                                                    @endif
                                                </div>
                                            </td>
                                        @if ($proc->count() > 0)
                                            @foreach ($proc as $item)
                                                <tr class="collapse {{($open_proc)?'show':''}}" id="proc">

                                                    <td>
                                                        <a href="/show_deal/{{ $item->id }}"
                                                            style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                            {{ $item->company_name }}.
                                                        </a>
                                                    </td>
                                                    <td>{{ $item->marchant_name }}</td>
                                                    <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                    <td>{{ $item->phone_number }}</td>
                                                    <td>{{ $item->email }}</td>
                                                    <td>{{ $item->sale_rep }}</td>
                                                    <td>{{ $item->date_submitted }}</td>
                                                    <td style="display: flex;">
                                                        <button type="button" class="btn btn-danger delete_deal"
                                                            data-id="{{ $item->id }}">
                                                            Delete
                                                        </button>
                                                        <button type="button" data-id="{{ $item->id }}"
                                                            class=" ms-2 btn-primary btn-sm btn">
                                                            Edit
                                                        </button>
                                                        @if($errors->any())
                                                            <script>
                                                                $(document).ready(function () {
                                                                    $('#add_deal').modal('show');
                                                                });
                                                            </script>
                                                        @endif             
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr></tr>
                                        @endif
                                        {{-- Underwritting --}}
                                            <td colspan="8">
                                                <div class="header-wrapper">
                                                    <a data-bs-toggle="collapse" class="collapse-link"
                                                        href="#underwritting" role="button" aria-expanded="false"
                                                        aria-controls="underwritting" style="min-width:10rem">
                                                        Underwriting({{ $underwritter->count() }})
                                                    </a>
                                                    @if($underwritter->count() > 0)
                                                        <a href="/deal/asc/underwritter">
                                                            <button class="btn btn-sm order-btn">▲</button>
                                                        </a>
                                                        <a href="/deal/desc/underwritter">
                                                            <button class="btn btn-sm order-btn">▼</button>
                                                    
                                                        </a>
                                                    @endif
                                                </div>
                                            </td>
                                        @if ($underwritter->count() > 0)
                                            @foreach ($underwritter as $item)
                                                <tr class="collapse {{($open_uw)?'show':''}}" id="underwritting">

                                                    <td>
                                                        <a href="/show_deal/{{ $item->id }}"
                                                            style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                            {{ $item->company_name }}.
                                                        </a>
                                                    </td>
                                                    <td>{{ $item->marchant_name }}</td>
                                                    <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                    <td>{{ $item->phone_number }}</td>
                                                    <td>{{ $item->email }}</td>
                                                    <td>{{ $item->sale_rep }}</td>
                                                    <td>{{ $item->date_submitted }}</td>
                                                    <td style="display: flex;">
                                                        <button type="button" class="btn btn-danger delete_deal"
                                                            data-id="{{ $item->id }}">
                                                            Delete
                                                        </button>
                                                        <button type="button" data-id="{{ $item->id }}"
                                                            class=" ms-2 btn-info btn-sm btn edit_deal">
                                                            Edit
                                                        </button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr></tr>
                                        @endif
                                        {{-- reshop --}}
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#reshop" role="button" aria-expanded="false" aria-controls="reshop" style="min-width:10rem">
                                                    Reshop({{ $reshop->count() }})
                                                </a>
                                                @if($reshop->count() > 0)
                                                    <a href="/deal/asc/reshop">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/reshop">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    @if ($reshop->count() > 0)
                                        @foreach ($reshop as $item)
                                            <tr class="collapse {{($open_reshop)?'show':''}}" id="reshop">

                                                <td>
                                                    <a href="/show_deal/{{ $item->id }}"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        {{ $item->company_name }}.
                                                    </a>
                                                </td>
                                                <td>{{ $item->marchant_name }}</td>
                                                <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                <td>{{ $item->phone_number }}</td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ $item->sale_rep }}</td>
                                                <td>{{ $item->date_submitted }}</td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="{{ $item->id }}">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="{{ $item->id }}"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    @if($errors->any())
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    @endif             
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr></tr>
                                    @endif
                                    {{-- Approve --}}

                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#approved" role="button" aria-expanded="false" aria-controls="approved" style="min-width:10rem">
                                                    Approved({{ $approved->count() }})
                                                </a>
                                                @if($approved->count() > 0)
                                                    <a href="/deal/asc/approved">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/approved">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    @if ($approved->count() > 0)
                                        @foreach ($approved as $item)
                                            <tr class="collapse {{($open_app)?'show':''}}" id="approved">

                                                <td>
                                                    <a href="/show_deal/{{ $item->id }}"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        {{ $item->company_name }}.
                                                    </a>
                                                </td>
                                                <td>{{ $item->marchant_name }}</td>
                                                <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                <td>{{ $item->phone_number }}</td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ $item->sale_rep }}</td>
                                                <td>{{ $item->date_submitted }}</td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="{{ $item->id }}">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="{{ $item->id }}"
                                                        class=" ms-2 btn-info btn-sm btn edit_deal">
                                                        Edit
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr></tr>
                                    @endif
                                    {{-- cold offer --}}
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#coldoffer" role="button" aria-expanded="false" aria-controls="coldoffer" style="min-width:10rem">
                                                    Cold offer({{ $coldoffer->count() }})
                                                </a>
                                                @if($coldoffer->count() > 0)
                                                    <a href="/deal/asc/coldoffer">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/coldoffer">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    @if ($coldoffer->count() > 0)
                                        @foreach ($coldoffer as $item)
                                            <tr class="collapse {{($open_cold)?'show':''}}" id="coldoffer">

                                                <td>
                                                    <a href="/show_deal/{{ $item->id }}"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        {{ $item->company_name }}.
                                                    </a>
                                                </td>
                                                <td>{{ $item->marchant_name }}</td>
                                                <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                <td>{{ $item->phone_number }}</td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ $item->sale_rep }}</td>
                                                <td>{{ $item->date_submitted }}</td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="{{ $item->id }}">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="{{ $item->id }}"
                                                        class=" ms-2 btn-info btn-sm btn edit_deal">
                                                        Edit
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr></tr>
                                    @endif
                                    {{-- open for team --}}
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#open_team" role="button" aria-expanded="false" aria-controls="open_team" style="min-width:10rem">
                                                    Open for team({{ $open_team->count() }})
                                                </a>
                                                @if($open_team->count() > 0)
                                                    <a href="/deal/asc/open_team">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/open_team">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    @if ($open_team->count() > 0)
                                        @foreach ($open_team as $item)
                                            <tr class="collapse {{($open_open_team)?'show':''}}" id="open_team">

                                                <td>
                                                    <a href="/show_deal/{{ $item->id }}"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        {{ $item->company_name }}.
                                                    </a>
                                                </td>
                                                <td>{{ $item->marchant_name }}</td>
                                                <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                <td>{{ $item->phone_number }}</td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ $item->sale_rep }}</td>
                                                <td>{{ $item->date_submitted }}</td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="{{ $item->id }}">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="{{ $item->id }}"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    @if($errors->any())
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    @endif             
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr></tr>
                                    @endif
                                    {{-- open  --}}
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#open" role="button" aria-expanded="false" aria-controls="open" style="min-width:10rem">
                                                    open({{ $open->count() }})
                                                </a>
                                                @if($open->count() > 0)
                                                    <a href="/deal/asc/open">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/open">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    @if ($open->count() > 0)
                                        @foreach ($open as $item)
                                            <tr class="collapse {{($open_open)?'show':''}}" id="open">

                                                <td>
                                                    <a href="/show_deal/{{ $item->id }}"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        {{ $item->company_name }}.
                                                    </a>
                                                </td>
                                                <td>{{ $item->marchant_name }}</td>
                                                <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                <td>{{ $item->phone_number }}</td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ $item->sale_rep }}</td>
                                                <td>{{ $item->date_submitted }}</td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="{{ $item->id }}">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="{{ $item->id }}"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    @if($errors->any())
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    @endif             
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr></tr>
                                    @endif
                                    {{-- funded --}}
                                    <td colspan="8">
                                        <div class="header-wrapper">
                                            <a data-bs-toggle="collapse" class="collapse-link" href="#funded" role="button" aria-expanded="false" aria-controls="funded" style="min-width:10rem">
                                                Funded({{ $funded->count() }})
                                            </a>
                                            @if($funded->count() > 0)
                                                <a href="/deal/asc/funded">
                                                    <button class="btn btn-sm order-btn">▲</button>
                                                </a>
                                                <a href="/deal/desc/funded">
                                                    <button class="btn btn-sm order-btn">▼</button>
                                            
                                                </a>
                                            @endif
                                        </div>
                                    </td>
                                @if ($funded->count() > 0)
                                    @foreach ($funded as $item)
                                        <tr class="collapse {{($open_funded)?'show':''}}" id="funded">

                                            <td>
                                                <a href="/show_deal/{{ $item->id }}"
                                                    style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                    {{ $item->company_name }}.
                                                </a>
                                            </td>
                                            <td>{{ $item->marchant_name }}</td>
                                            <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                            <td>{{ $item->phone_number }}</td>
                                            <td>{{ $item->email }}</td>
                                            <td>{{ $item->sale_rep }}</td>
                                            <td>{{ $item->date_submitted }}</td>
                                            <td style="display: flex;">
                                                <button type="button" class="btn btn-danger delete_deal"
                                                    data-id="{{ $item->id }}">
                                                    Delete
                                                </button>
                                                <button type="button" data-id="{{ $item->id }}"
                                                    class=" ms-2 btn-primary btn-sm btn">
                                                    Edit
                                                </button>
                                                @if($errors->any())
                                                    <script>
                                                        $(document).ready(function () {
                                                            $('#add_deal').modal('show');
                                                        });
                                                    </script>
                                                @endif             
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr></tr>
                                @endif
                                    {{-- doc offer --}}
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#doc" role="button" aria-expanded="false" aria-controls="doc" style="min-width:10rem">
                                                    Doc's Offer({{ $doc->count() }})
                                                </a>
                                                @if($doc->count() > 0)
                                                    <a href="/deal/asc/doc">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/doc">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    @if ($doc->count() > 0)
                                        @foreach ($doc as $item)
                                            <tr class="collapse {{($open_doc)?'show':''}}" id="doc">

                                                <td>
                                                    <a href="/show_deal/{{ $item->id }}"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        {{ $item->company_name }}.
                                                    </a>
                                                </td>
                                                <td>{{ $item->marchant_name }}</td>
                                                <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                <td>{{ $item->phone_number }}</td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ $item->sale_rep }}</td>
                                                <td>{{ $item->date_submitted }}</td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="{{ $item->id }}">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="{{ $item->id }}"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    @if($errors->any())
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    @endif             
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr></tr>
                                    @endif

                                    {{-- dead --}}
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#dead" role="button" aria-expanded="false" aria-controls="dead" style="min-width:10rem">
                                                    Dead({{ $dead->count() }})
                                                </a>
                                                @if($dead->count() > 0)
                                                    <a href="/deal/asc/dead">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/dead">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    @if ($dead->count() > 0)
                                        @foreach ($dead as $item)
                                            <tr class="collapse {{($open_dead)?'show':''}}" id="dead">

                                                <td>
                                                    <a href="/show_deal/{{ $item->id }}"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        {{ $item->company_name }}.
                                                    </a>
                                                </td>
                                                <td>{{ $item->marchant_name }}</td>
                                                <td style="display: flex;">
                                                @php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                @endphp

                                                @foreach ($approvedNotes as $note)
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>
                                                @endforeach

                                                @foreach ($pendingNotes as $note)
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}
                                                </p>
                                                @endforeach

                                                @foreach ($declinedNotes as $note)
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>
                                                @endforeach
                                            </td>
                                                <td>{{ $item->phone_number }}</td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ $item->sale_rep }}</td>
                                                <td>{{ $item->date_submitted }}</td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="{{ $item->id }}">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="{{ $item->id }}"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    @if($errors->any())
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    @endif             
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr></tr>
                                    @endif

{{--                                    @if (auth()->user()->role('Admin'))--}}
{{--                                    @if ($need_approve->count() > 0)--}}
{{--                                    <td colspan="8">--}}
{{--                                        <div class="header-wrapper">--}}
{{--                                            <a data-bs-toggle="collapse" class="collapse-link" href="#need_approve" role="button" aria-expanded="false" aria-controls="need_approve" style="min-width:10rem">--}}
{{--                                                need_approve({{ $need_approve->count() }})--}}
{{--                                            </a>--}}
{{--                                            <a href="/deal/asc/need_approve">--}}
{{--                                                <button class="btn btn-sm order-btn">▲</button>--}}
{{--                                            </a>--}}
{{--                                            <a href="/deal/desc/need_approve">--}}
{{--                                                <button class="btn btn-sm order-btn">▼</button>--}}
{{--                                            </a>--}}
{{--                                        </div>--}}
{{--                                    </td>--}}
{{--                                    @foreach ($need_approve as $item)--}}
{{--                                        <tr class="collapse {{($need_approve)?'show':''}}" id="need_approve">--}}

{{--                                            <td>--}}
{{--                                                <a href="/show_deal/{{ $item->id }}"--}}
{{--                                                    style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">--}}
{{--                                                    {{ $item->company_name }}.--}}
{{--                                                </a>--}}
{{--                                            </td>--}}
{{--                                            <td>{{ $item->marchant_name }}</td>--}}
{{--                                            <td style="display: flex;">--}}
{{--                                                @php--}}
{{--                                                $approvedNotes = [];--}}
{{--                                                $pendingNotes = [];--}}
{{--                                                $declinedNotes = [];--}}

{{--                                                foreach ($item->lenders as $lender) {--}}
{{--                                                if ($lender->pivot->status == 'Approved') {--}}
{{--                                                $approvedNotes[] = $lender->pivot->note;--}}
{{--                                                } elseif ($lender->pivot->status == 'Pending') {--}}
{{--                                                $pendingNotes[] = $lender->pivot->note;--}}
{{--                                                } elseif ($lender->pivot->status == 'Declined') {--}}
{{--                                                $declinedNotes[] = $lender->pivot->note;--}}
{{--                                                }--}}
{{--                                                }--}}
{{--                                                @endphp--}}

{{--                                                @foreach ($approvedNotes as $note)--}}
{{--                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success">{{ Str::limit($note, 8) }}</p>--}}
{{--                                                @endforeach--}}

{{--                                                @foreach ($pendingNotes as $note)--}}
{{--                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning">{{ Str::limit($note, 8) }}--}}
{{--                                                </p>--}}
{{--                                                @endforeach--}}

{{--                                                @foreach ($declinedNotes as $note)--}}
{{--                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger">{{ Str::limit($note, 8) }}</p>--}}
{{--                                                @endforeach--}}
{{--                                            </td>--}}
{{--                                            <td>{{ $item->phone_number }}</td>--}}
{{--                                            <td>{{ $item->email }}</td>--}}
{{--                                            <td>{{ $item->sale_rep }}</td>--}}
{{--                                            <td>{{ $item->date_submitted }}</td>--}}
{{--                                            <td style="display: flex;">--}}
{{--                                                <form action="{{route('deals.approve_status')}}" method="post">--}}
{{--                                                    @csrf--}}
{{--                                                    <input type="hidden" name="id" value="{{$item->id}}">--}}
{{--                                                    <button type="submit" class="btn btn-danger approve_need_approve">--}}
{{--                                                    Approve--}}
{{--                                                </button>   --}}
{{--                                                </form>    --}}
{{--                                            </td>--}}
{{--                                        </tr>--}}
{{--                                    @endforeach--}}
{{--                                    @endif--}}
{{--                                    @endif--}}
{{--                                    </tr>--}}


                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>


            </div>
    </div>
    </main>

    </div>


    @if (Session::has('success'))
        <script>
            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: "{!! Session::get('success') !!}",
                showConfirmButton: false,
                timer: 1500
            })
        </script>
    @endif
    {{-- <script>
        $(document).ready(function() {
            $('.order-btn').click(function() {
                var sort = $(this).data('sort');
                var type=$(this).data('type');
                $.ajax({
                url: '/deal/sort',
                method: 'GET',
                data: { sort: sort,type:type },
                success: function(data) {
                    $('tbody').html(data);
                }
                });
            });
        });

    </script> --}}
@endsection
<!-- add deal Modal -->
@include('partials.deal_modal')
@include('partials.edit_deal')
{{-- assign  lender modal --}}

{{-- @include('partials.assign_lender') --}}