@extends('layouts.app')
@section('title')
    Import
@endsection
@section('content')
    @include('partials.navbar')
    <div class="content-wrapper">
        @include('partials.sidebar')

        <main class="main-container" id="main_container">
            <div class="container-fluid w-100">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="text-info">Import</h5>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="ms-2">
                                        <span>
                                            <i class='bx bx-cog'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-caret-down'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-sync'></i>
                                        </span>
                                    </div>

                                </div>

                            </div>
                            <div class="card-body">
                                <div class="table-wrapper">
                                    <div class="row">
                                        <form action="{{route('import.add')}}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <div class="row mb-2">
                                                <label for="lenders" class="col-sm-2 col-form-label">Import Lenders Excel</label>
                                                <div class="col-sm-1">
                                                    <a href="{{ asset('demo/lender.xlsx') }}" class="btn btn-sm btn-primary">Demo</a>
                                                </div>
                                                <div class="col-sm-9">
                                                   <input class="form-control form-control-sm" type="file" id="files" name="lender" id="lender">
                                                </div>
                                                @error('lender')
                                                    <p class="text-danger fw-semibold">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="row mb-2">
                                                <label for="deal" class="col-sm-2 col-form-label">Import Deal Excel</label>
                                                <div class="col-sm-1">
                                                    <a href="{{ asset('demo/deal.xlsx') }}" class="btn btn-sm btn-primary">Demo</a>
                                                </div>
                                                <div class="col-sm-9">
                                                   <input class="form-control form-control-sm" type="file" name="deal" id="deal">
                                                </div>
                                                @error('deal')
                                                    <p class="text-danger fw-semibold">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="row mb-2">
                                                <label for="user" class="col-sm-2 col-form-label">Import Users Excel</label>
                                                <div class="col-sm-1">
                                                    <a href="{{ asset('demo/user.xlsx') }}" class="btn btn-sm btn-primary">Demo</a>
                                                </div>
                                                <div class="col-sm-9">
                                                   <input class="form-control form-control-sm" type="file" name="user" id="user">
                                                </div>
                                                @error('user')
                                                    <p class="text-danger fw-semibold">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="modal-footer">
                                                <input type="submit" class="btn submit_button" value="Save">
                                            </div>
                                        </form>


                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
    </div>
    </div>
    </main>
    </div>

    @if (Session::has('success'))
        <script>
            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: "{!! Session::get('success') !!}",
                showConfirmButton: false,
                timer: 1500
            });
        </script>
    @endif
    @if (Session::has('error'))
        <script>
            Swal.fire({
                position: 'top-end',
                icon: 'error',
                title: "{!! Session::get('error') !!}",
                showConfirmButton: false,
                timer: 1500
            });
        </script>
    @endif
    </body>
@endsection
