@include('partials.lender_modal')
@include('partials.edit_lender')
@extends('layouts.app')

@section('content')
@include('partials.navbar')
@include('partials.sidebar')
<div class="content-wrapper">
	<main class="main-container" id="main_container">
		<div class="container-fluid w-100">
			<div class="row">
				<div class="col-12">
					<div class="card">
						<div class="card-header d-flex justify-content-between align-items-center">
							<div>
								<h5 class="text-info">VENDOR DASHBOARD</h5>
							</div>
							<div class="d-flex justify-content-between align-items-center">
								<div>
         <a href="#" class="btn custom-btn ms-3" data-bs-toggle="modal" data-bs-target="#add_lender">
										<i class='fas fa-plus'></i>
										Add Lender
									</a>
								</div>
								<div class="ms-2">
									<span>
										<i class='fas fa-caret-down'></i>
									</span>
								</div>
								<div class="ms-2">
									<span>
										<i class='fas fa-sync'></i>
									</span>
								</div>
							</div>
						</div>
						<div class="card-body">
							<div class="table-wrapper">
								<div class="row">
									<div class="col-12 mt-1">
										@foreach ($errors->all() as $message)
											<p class="text-danger fw-bold">{{ $message }}</p>
										@endforeach
									</div>
									<div class="col-12 mb-2">
										<form action="{{ url('lender/search') }}" method="post" class="row g-2 align-items-center">
											@csrf
											<div class="col">
												<input type="text" name="company_name" class="form-control" placeholder="Company Name" />
											</div>
											<div class="col">
												<input type="text" name="primary_contact" class="form-control" placeholder="Primary Contact" />
											</div>
{{--											<div class="col">--}}
{{--												<input type="text" name="code" class="form-control" placeholder="Code" />--}}
{{--											</div>--}}
											<div class="col">
												<input type="text" name="phone" class="form-control" placeholder="Phone" />
											</div>
											<div class="col">
												<input type="text" name="email" class="form-control" placeholder="Email" />
											</div>
											<div class="col">
												<input type="date" name="last_contacted" class="form-control" />
											</div>
											<div class="col-auto">
												<button type="submit" class="btn btn-primary">Search</button>
											</div>
										</form>
									</div>
									<div class="col-sm-6">
										<div class="border border-light w-100 d-flex flex-column p-2">
											<div>
												<h5 class="text-muted">Vendors</h5>
											</div>
											<div>
												<div class="d-flex justify-content-start gap-5 align-items-center">
													<div style="width:60px;height:60px;background-color:rgb(97, 226, 226);position: relative;">
														<i class='fas fa-user fa-lg' style="color: white; position: absolute; top: 31%; left: 31%;"></i>
													</div>
													<div class="d-flex flex-column">
														<span class="text-muted fw-semibold">All</span>
														<span class="text-muted fw-bold">{{ isset($lenders) ? $lenders->count() : 0 }}</span>
													</div>
																				@include('partials.deal_modal')
												</div>
											</div>
										</div>
									</div>
									<div class="col-12">
										<table class="table table-striped">
											<thead>
												<tr>
													<th scope="col">Company</th>
													<th scope="col">Primary Contact</th>
{{--													<th scope="col">Code</th>--}}
													<th scope="col">Phone Number</th>
													<th scope="col">Email Address</th>
													<th scope="col">Last Contacted</th>
													<th scope="col">Status</th>
													<th scope="col">Action</th>
												</tr>
											</thead>
											<tbody>
												@forelse ($lenders as $item)
													<tr>
														<td>{{ $item->company_name }}</td>
														<td>{{ $item->primary_contact }}</td>
{{--														<td>{{ $item->code }}</td>--}}
														<td>{{ $item->phone }}</td>
														<td>{{ $item->email }}</td>
														<td>{{ $item->last_contacted }}</td>
														<td>{{ $item->status }}</td>
														<td>
															@role('Admin')
                                                                <a class="edit_lender" href="#" role="button" data-id="{{ $item->id }}">
                                                                    <i class="fas fa-edit fa-lg text-info"></i>
                                                                </a>

																<a href="#" class="delete_lender" role="button" data-id="{{ $item->id }}">
																	<i class="fas fa-trash-alt fa-lg text-danger"></i>
																</a>
															@endrole
														</td>
													</tr>
												@empty
													<tr>
														<td colspan="8" class="text-center">No lenders found</td>
													</tr>
												@endforelse
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</main>
</div>
@endsection
