<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lender Update Debug</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        pre {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            padding: 1rem;
            border-radius: .25rem;
            max-height: 60vh;
            overflow: auto;
        }
        .small-muted { font-size: .9rem; color: #6c757d; }
    </style>
</head>
<body>
<div class="container py-4">
    <div class="d-flex align-items-center mb-3">
        <h1 class="h4 mb-0">Debug: Lender Update Payload</h1>
        <span class="badge bg-warning text-dark ms-3">No data was saved</span>
    </div>

    <p class="small-muted mb-4">
        This is a debug view for <code>{{ $route ?? request()->url() }}</code> at <strong>{{ $timestamp ?? now()->toDateTimeString() }}</strong>.
        The form submission was intercepted and nothing has been persisted to the database.
    </p>

    <div class="row g-4">
        <div class="col-12 col-lg-6">
            <div class="card">
                <div class="card-header">
                    Clean Payload (without framework fields)
                </div>
                <div class="card-body">
                    <pre class="mb-0">
                        {{
                            json_encode(
                                ($payload ?? request()->except(['_token','_method','__debug'])),
                                JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE
                            )
                        }}
                    </pre>

                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6">
            <div class="card">
                <div class="card-header">
                    Raw Request
                </div>
                <div class="card-body">
                    <pre class="mb-0">{{ json_encode(($raw ?? request()->all()), JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}</pre>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-4 d-flex gap-2">
        <a href="{{ url()->previous() }}" class="btn btn-secondary">Back</a>
        <a href="{{ route('lenders') }}" class="btn btn-outline-primary">Go to Lenders</a>
    </div>
</div>
</body>
</html>
