<div class="modal fade" id="assignModal" tabindex="-1" aria-labelledby="assignModal" aria-hidden="true">
    <div class="modal-lg modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title fs-5 text-muted" id="assignModal">Assign Lenders - Rep {{ $deal->sale_rep }}</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <button class="btn  w-100"
                            style="background-color: #e9ecef; box-shadow: -5px 0px rgb(0, 174, 255);">
                            Click a Lender To Assign/Unassign to This Loan
                        </button>
                        <div class="mt-2 mb-2">
                            <input type="text" id="search_pos_field" name="" placeholder="filter by position"
                                class="form-control form-control-sm" id="">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-1 p-2 d-flex align-items-center gap-3 flex-wrap">
                            <div class="d-flex align-items-center">
                                <input type="checkbox" class="form-check-control me-2" id="checkAll">
                                <span>-Check All</span>
                            </div>
                            <button type="button" class="btn btn-sm btn-outline-success" id="selectMatches">Select all matches</button>
                            <button type="button" class="btn btn-sm btn-outline-secondary" id="clearSelection">Clear selection</button>
                            <span class="ms-auto small text-muted" id="selectionCounter">Selected 0 of {{ isset($totalActiveLenders)?$totalActiveLenders:$lenders->count() }} active ({{ isset($totalMatchingLenders)?$totalMatchingLenders:$lenders->where('matches',true)->count() }} matches)</span>
                        </div>
                        <form action="{{ url('assign_lender') }}" method="post">
                            @csrf
                            <input type="hidden" name="deal_id" value="{{ $deal->id }}">

                            @foreach ($lenders as $item)
                                <div class="mb-1 p-2 border d-flex align-items-center justify-content-between check_box_parent {{ Str::lower($item->position) }} border-light {{ $item->position }} ">
                                    <div class="d-flex align-items-center">
                                        <input type="checkbox" class="form-check-control me-3 lender-checkbox"
                                            name="lenders[]" id="{{ $item->id }}" value="{{ $item->id }}"
                                            @if (in_array($item->id, $deal_lenders_asigned)) checked @elseif (!empty($item->matches) && $item->matches) checked @endif>
                                        <div>
                                            <div class="d-flex align-items-center gap-2">
                                                <span>{{ $item->company_name }}@if($item->position), {{ $item->position }}@endif</span>
                                                @if (in_array($item->id, $deal_lenders_asigned))
                                                    <span class="badge bg-primary">Assigned</span>
                                                @endif
                                                @if (!empty($item->matches) && $item->matches)
                                                    <span class="badge bg-success">Matches</span>
                                                @else
                                                    <span class="badge bg-light text-dark">No match</span>
                                                @endif
                                            </div>
                                            @if (!empty($item->criteria_summary))
                                            <div class="text-muted small" title="{{ $item->criteria_summary }}">{{ $item->criteria_summary }}</div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn submit_button" data-bs-dismiss="modal">Close</button>
                <button type="submit" class="btn submit_button" id="submit_button">Submit</button>
            </div>
            </form>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        function updateCounter(){
            var total = $('.lender-checkbox').length;
            var selected = $('.lender-checkbox:checked').length;
            var matches = $('.lender-checkbox').filter(function(){ return $(this).closest('.check_box_parent').find('.badge.bg-success').length>0; }).length;
            $('#selectionCounter').text('Selected ' + selected + ' of ' + total + ' active (' + matches + ' matches)');
            $('#submit_button').prop('disabled', selected < 1);
        }
        updateCounter();

        $('#checkAll').click(function() {
            var checkboxes = $('input[name="lenders[]"]');
            checkboxes.prop('checked', $(this).prop('checked'));
            updateCounter();
        });

        $('#selectMatches').click(function(){
            $('.check_box_parent').each(function(){
                if($(this).find('.badge.bg-success').length>0){
                    $(this).find('.lender-checkbox').prop('checked', true);
                }
            });
            updateCounter();
        });
        $('#clearSelection').click(function(){
            $('.lender-checkbox').prop('checked', false);
            $('#checkAll').prop('checked', false);
            updateCounter();
        });

        $('#search_pos_field').keyup(function() {
            var search_pos_field = $(this).val();
            if (search_pos_field == '') {
               $('.check_box_parent').removeAttr("style");
            } else {
                $('.check_box_parent').each(function() {
                    $(this).attr("style", "display: none !important");
                    if ($(this).hasClass(search_pos_field)) {
                        $(this).removeAttr("style");
                    } 
                });
            }
        });
        $(document).on('change', '.lender-checkbox', function(){
            updateCounter();
        });

    });
</script>

