<div class="modal fade" id="add_team" tabindex="-1" aria-labelledby="add_team" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="add_team">Add Team</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="POST" action="{{ route('team.store') }}">
                    @csrf

                    <div class="row mb-2">
                        <label for="name" class="col-sm-2 col-form-label"> Name</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control form-control-sm" name="name"
                                value="{{old('name')}}" id="name">
                        </div>
                        @error('name')
                            <p class="text-danger fw-semibold">{{ $message }}</p>
                        @enderror
                    </div>
                   <div class="row mb-2">
                        <label for="role" class="col-sm-2 col-form-label">Leader</label>
                        <div class="col-sm-10" >
                            <select class="form-select form-select-sm js-example-basic-multiple-add" name="team_leader_id[]" id="team_leader_id" multiple="multiple" style="width: 50%">
                                {{-- <option>Select</option> --}}
                                @foreach ($users as $user)
                                    <option value="{{$user->id}}">{{$user->name}}</option>
                                @endforeach                               
                               
                            </select>
                        </div>
                        @error('team_leader_id')
                            <p class="text-danger fw-semibold">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="row mb-2">
                        <label for="members" class="col-sm-2 col-form-label">Team Members</label>
                        <div class="col-sm-10">
                            @foreach($users as $user)
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="members[]" value="{{ $user->id }}" id="member_{{ $user->id }}">
                                    <label class="form-check-label" for="member_{{ $user->id }}">
                                        {{ $user->name }}
                                    </label>
                                </div>
                            @endforeach
                        </div>
                        @error('members')
                            <p class="text-danger fw-semibold">{{ $message }}</p>
                        @enderror
                    </div>
                  
            </div>
            <div class="modal-footer">

                <button type="submit" class="btn submit_button">Submit</button>

                </form>
            </div>
        </div>
    </div>
</div>