@extends('layouts.app')
@section('title')
    Settings
@endsection
@section('content')
@include('partials.navbar')
<div class="content-wrapper">
    @include('partials.sidebar')
    <main class="main-container" id="main_container">
        <div class="container-fluid w-100">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="text-info">Settings</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('settings.update') }}">
                                @csrf
                                <div class="mb-3">
                                    <label for="max_sales_cm" class="form-label">Default Max Sales Commission (%)</label>
                                    <input type="number" step="0.01" min="0" max="100" class="form-control" id="max_sales_cm" name="max_sales_cm" value="{{ $settings->where('key','max_sales_cm')->first()->value ?? 45 }}">
                                </div>
                                <!-- Add more settings fields as needed -->
                                <button type="submit" class="btn btn-primary">Save Settings</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
@endsection
