<?php if(auth()->guard()->check()): ?>
<div class="sidebar" id="left_sidebar">
  <div class="menu">
    <div class="item">
      <a href="#" class="sub-btn semi-active" style="color:#fff;">
        <i class='fas fa-bars icon'></i>
        Finance
        <i class='fas fa-angle-down dropdown'></i>
      </a>

      <div class="sub-menu">
        
        <?php if(Route::has('deals.index')): ?>
          <a href="<?php echo e(route('deals.index')); ?>"
             class="sub-item <?php echo e(request()->routeIs('deals.*') ? 'side_active' : ''); ?>">
            Deals
          </a>
        <?php else: ?>
          <a href="/deals"
             class="sub-item <?php echo e(request()->is('deals*') ? 'side_active' : ''); ?>">
            Deals
          </a>
        <?php endif; ?>

        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Admin|Processor')): ?>
          
          <?php if(Route::has('lenders')): ?>
            <a href="<?php echo e(route('lenders')); ?>"
               class="sub-item <?php echo e((request()->routeIs('lenders*') || request()->routeIs('lender.*')) ? 'side_active' : ''); ?>">
              Lenders
            </a>
          <?php endif; ?>

          
          <?php if(Route::has('team.index')): ?>
            <a href="<?php echo e(route('team.index')); ?>"
               class="sub-item <?php echo e(request()->routeIs('team.*') ? 'side_active' : ''); ?>">
              Teams
            </a>
          <?php endif; ?>
        <?php endif; ?>

        
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('import.excel')): ?>
          <?php if(Route::has('import.index')): ?>
            <a href="<?php echo e(route('import.index')); ?>"
               class="sub-item <?php echo e(request()->routeIs('import.*') ? 'side_active' : ''); ?>">
              Imports
            </a>
          <?php endif; ?>
        <?php endif; ?>

        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Admin')): ?>
          
          <?php if(Route::has('users.index')): ?>
            <a href="<?php echo e(route('users.index')); ?>"
               class="sub-item <?php echo e(request()->routeIs('users.*') ? 'side_active' : ''); ?>">
              Users
            </a>
          <?php endif; ?>

          
          <?php if(Route::has('email.index')): ?>
            <a href="<?php echo e(route('email.index')); ?>"
               class="sub-item <?php echo e(request()->routeIs('email.*') ? 'side_active' : ''); ?>">
              Email
            </a>
          <?php endif; ?>

          
          <?php if(Route::has('commissions.index')): ?>
            <a href="<?php echo e(route('commissions.index')); ?>"
               class="sub-item <?php echo e(request()->routeIs('commissions.*') ? 'side_active' : ''); ?>">
              Commissions
            </a>
          <?php endif; ?>

          
          <?php if(Route::has('settings.index')): ?>
            <a href="<?php echo e(route('settings.index')); ?>"
               class="sub-item <?php echo e(request()->routeIs('settings.*') ? 'side_active' : ''); ?>">
              Settings
            </a>
          <?php endif; ?>

          
          <?php if(Route::has('dashboard.index')): ?>
            <a href="<?php echo e(route('dashboard.index')); ?>"
               class="sub-item <?php echo e(request()->routeIs('dashboard.*') ? 'side_active' : ''); ?>">
              Dashboard
            </a>
          <?php endif; ?>
        <?php endif; ?>

        
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
  if (window.console) console.log('Sidebar loaded');
  fetch('/__test', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
    },
    body: JSON.stringify({msg: 'sidebar_loaded'})
  }).catch(()=>{});
});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/funderscrm/public_html/resources/views/partials/sidebar.blade.php ENDPATH**/ ?>