<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class NetworkEndpointGroupsListNetworkEndpoints extends \Google\Collection
{
  protected $collection_key = 'items';
  /**
   * [Output Only] Unique identifier for the resource; defined by the server.
   *
   * @var string
   */
  public $id;
  protected $itemsType = NetworkEndpointWithHealthStatus::class;
  protected $itemsDataType = 'array';
  /**
   * [Output Only] The resource type, which is
   * alwayscompute#networkEndpointGroupsListNetworkEndpoints for the list of
   * network endpoints in the specified network endpoint group.
   *
   * @var string
   */
  public $kind;
  /**
   * [Output Only] This token allows you to get the next page of results for
   * list requests. If the number of results is larger thanmaxResults, use the
   * nextPageToken as a value for the query parameter pageToken in the next list
   * request. Subsequent list requests will have their own nextPageToken to
   * continue paging through the results.
   *
   * @var string
   */
  public $nextPageToken;
  protected $warningType = NetworkEndpointGroupsListNetworkEndpointsWarning::class;
  protected $warningDataType = '';

  /**
   * [Output Only] Unique identifier for the resource; defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * A list of NetworkEndpointWithHealthStatus resources.
   *
   * @param NetworkEndpointWithHealthStatus[] $items
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return NetworkEndpointWithHealthStatus[]
   */
  public function getItems()
  {
    return $this->items;
  }
  /**
   * [Output Only] The resource type, which is
   * alwayscompute#networkEndpointGroupsListNetworkEndpoints for the list of
   * network endpoints in the specified network endpoint group.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * [Output Only] This token allows you to get the next page of results for
   * list requests. If the number of results is larger thanmaxResults, use the
   * nextPageToken as a value for the query parameter pageToken in the next list
   * request. Subsequent list requests will have their own nextPageToken to
   * continue paging through the results.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * [Output Only] Informational warning message.
   *
   * @param NetworkEndpointGroupsListNetworkEndpointsWarning $warning
   */
  public function setWarning(NetworkEndpointGroupsListNetworkEndpointsWarning $warning)
  {
    $this->warning = $warning;
  }
  /**
   * @return NetworkEndpointGroupsListNetworkEndpointsWarning
   */
  public function getWarning()
  {
    return $this->warning;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NetworkEndpointGroupsListNetworkEndpoints::class, 'Google_Service_Compute_NetworkEndpointGroupsListNetworkEndpoints');
