<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Firestore;

class BatchWriteRequest extends \Google\Collection
{
  protected $collection_key = 'writes';
  /**
   * Labels associated with this batch write.
   *
   * @var string[]
   */
  public $labels;
  protected $writesType = Write::class;
  protected $writesDataType = 'array';

  /**
   * Labels associated with this batch write.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * The writes to apply. Method does not apply writes atomically and does not
   * guarantee ordering. Each write succeeds or fails independently. You cannot
   * write to the same document more than once per request.
   *
   * @param Write[] $writes
   */
  public function setWrites($writes)
  {
    $this->writes = $writes;
  }
  /**
   * @return Write[]
   */
  public function getWrites()
  {
    return $this->writes;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BatchWriteRequest::class, 'Google_Service_Firestore_BatchWriteRequest');
