<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SQLAdmin;

class SqlInstancesExecuteSqlResponse extends \Google\Collection
{
  protected $collection_key = 'results';
  protected $messagesType = Message::class;
  protected $messagesDataType = 'array';
  protected $metadataType = Metadata::class;
  protected $metadataDataType = '';
  protected $resultsType = QueryResult::class;
  protected $resultsDataType = 'array';
  protected $statusType = Status::class;
  protected $statusDataType = '';

  /**
   * A list of notices and warnings generated during query execution. For
   * PostgreSQL, this includes all notices and warnings. For MySQL, this
   * includes warnings generated by the last executed statement. To retrieve all
   * warnings for a multi-statement query, `SHOW WARNINGS` must be executed
   * after each statement.
   *
   * @param Message[] $messages
   */
  public function setMessages($messages)
  {
    $this->messages = $messages;
  }
  /**
   * @return Message[]
   */
  public function getMessages()
  {
    return $this->messages;
  }
  /**
   * The additional metadata information regarding the execution of the SQL
   * statements.
   *
   * @param Metadata $metadata
   */
  public function setMetadata(Metadata $metadata)
  {
    $this->metadata = $metadata;
  }
  /**
   * @return Metadata
   */
  public function getMetadata()
  {
    return $this->metadata;
  }
  /**
   * The list of results after executing all the SQL statements.
   *
   * @param QueryResult[] $results
   */
  public function setResults($results)
  {
    $this->results = $results;
  }
  /**
   * @return QueryResult[]
   */
  public function getResults()
  {
    return $this->results;
  }
  /**
   * Contains the error from the database if the SQL execution failed.
   *
   * @param Status $status
   */
  public function setStatus(Status $status)
  {
    $this->status = $status;
  }
  /**
   * @return Status
   */
  public function getStatus()
  {
    return $this->status;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SqlInstancesExecuteSqlResponse::class, 'Google_Service_SQLAdmin_SqlInstancesExecuteSqlResponse');
