<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Sheets;

class BigQueryTableSpec extends \Google\Model
{
  /**
   * The BigQuery dataset id.
   *
   * @var string
   */
  public $datasetId;
  /**
   * The BigQuery table id.
   *
   * @var string
   */
  public $tableId;
  /**
   * The ID of a BigQuery project the table belongs to. If not specified, the
   * project_id is assumed.
   *
   * @var string
   */
  public $tableProjectId;

  /**
   * The BigQuery dataset id.
   *
   * @param string $datasetId
   */
  public function setDatasetId($datasetId)
  {
    $this->datasetId = $datasetId;
  }
  /**
   * @return string
   */
  public function getDatasetId()
  {
    return $this->datasetId;
  }
  /**
   * The BigQuery table id.
   *
   * @param string $tableId
   */
  public function setTableId($tableId)
  {
    $this->tableId = $tableId;
  }
  /**
   * @return string
   */
  public function getTableId()
  {
    return $this->tableId;
  }
  /**
   * The ID of a BigQuery project the table belongs to. If not specified, the
   * project_id is assumed.
   *
   * @param string $tableProjectId
   */
  public function setTableProjectId($tableProjectId)
  {
    $this->tableProjectId = $tableProjectId;
  }
  /**
   * @return string
   */
  public function getTableProjectId()
  {
    return $this->tableProjectId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BigQueryTableSpec::class, 'Google_Service_Sheets_BigQueryTableSpec');
